	#pragma rtGlobals=1		// Use modern global access method.

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												1 ELECTRON
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    

Macro Macro1e(particle,xg,yg,tp0,t0,E,B)
	variable xg =0
	variable yg= 0
	variable tp0 =692
	variable t0 = 96
	variable E=3.9
	variable B= 5.65
	String particle="e1"	
	Prompt particle, "Particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt E, "Electric Field (V/cm)"
	Prompt B, "Magnetic Field (Gauss)"

	macro1e_EB(particle,xg,yg,tp0,t0,E,B)
End


Proc macro1e_EB(particle,xg,yg,tp0,t0,E,B)
	String particle	
	variable xg, yg,tp0,t0,E,B
	variable tau,WaveSize

	Variable timerRefNum, microSeconds	
	Silent 1;
	//Print "============= Start Conversion  Particle : ",particle,"============= "
	timerRefNum = startMSTimer

	tau=tp0/10+t0
	WaveSize=numpnts($("x_"+particle))
	make/O/D/N=(Wavesize)$("px_"+particle),$("py_"+particle),$("pz_"+particle)

	//Calcul Momenta
	Px_EB($("x_"+particle),$("y_"+particle),$("t_"+particle),xg,yg,tau,B,$("px_"+particle))
	Py_EB($("x_"+particle),$("y_"+particle),$("t_"+particle),xg,yg,tau,B,$("py_"+particle))
	Pz_Elin($("t_"+particle),tp0,E,$("pz_"+particle))
	//Pz_Eexa($("t_"+particle),tp0,tau,E,$("pz_"+particle))

	
	Histo_Momenta(particle,"w_e",-120,120,20, 100)
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Momenta Calculation Elapse Time (Sec)=", microSeconds/1e6	
	
	timerRefNum = startMSTimer
	// Calcul Energy-Angle

	AngleEnergy(particle)
	microSeconds = stopMSTimer(timerRefNum)	
	//Print "Angles & Energy Calculation Elapse Time (Sec)=", microSeconds/1e6	
	
End
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												2 ELECTRONS
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Macro Macro2e(particle1, particle2,xg,yg,tp0,t0,E,B)
	variable xg =0
	variable yg= 0
	variable tp0 =692
	variable t0 = 96
	variable E=3.9
	variable B= 5.65
	String particle1="e1"	
	String particle2="e2"
	Prompt particle1, "1rst particle label"
	Prompt particle2, "2nd particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt E, "Electric Field (V/cm)"
	Prompt B, "Magnetic Field (Gauss)"

	macro2e_EB(particle1, particle2,xg,yg,tp0,t0,E,B)
End




Proc macro2e_EB(particle1,particle2, xg,yg,tp0,t0,E,B)
	String particle1,particle2
	variable xg,yg,tp0,t0,B,E	
	
	Variable timerRefNum, microSeconds
	Silent 1;		
	
	macro1e_EB(particle1,xg,yg,tp0,t0,E,B)
	macro1e_EB(particle2,xg,yg,tp0,t0,E,B)
	
	Print "============= Correlate Particles ============= "
	timerRefNum = startMSTimer
	Correlation(particle1,particle2)
	microSeconds = stopMSTimer(timerRefNum)	
	Print "Correlation Calculation Elapse Time (Sec)=", microSeconds/1e6	
End
	      

